﻿using System;
using System.Linq;

namespace BasicLinqToEntities
{
    class Program
    {
        static void Main(string[] args)
        {
            // Listing 14-2. Rozwiązanie wykorzystujące technikę LINQ to Entities zamiast mechanizmu ADO.NET
            string state = "California";
            using (var context = new AdventureWorksLT2008Entities())
            {
                var addresses = from address in context.Addresses
                                where address.StateProvince == state
                                select address;

                foreach (var address in addresses)
                {
                    Console.WriteLine(address.AddressLine1);
                    Console.WriteLine(address.AddressLine2);
                    Console.WriteLine(address.City);
                }
            }
        }
    }
}
